<?php
/* Trang web Đại Tạng Kinh được lập trình bởi Xuân Duật và đây là mã nguồn mở */

include_once('func.php');

if(isset($_POST['activate'])) { $activate = $_POST['activate']; $activate();}
if(isset($_GET['activate'])) { $activate = $_GET['activate']; $activate();}
if(isset($_GET['dict'])) { dict($_GET['dict']);}

function dict($w)
{
	$Han = getHan(strip_tag($w));	
	if(offline()) han_viet($Han);//admin
	dict_cedict_ts($Han);//MDBG CEDICT
	if(!english())
	{
		echo '<div class=dotted></div>';
		dict_hz('hv_tc.db', $Han);
		dict_hz('hv_tvc.db', $Han);
	}
	else
	{
		echo '<div class=dotted></div>';
		dict_hz('lazyworm_ce.db', $Han);//H-E 懶蟲簡明漢英詞典
		dict_hz('langdao_ce.db', $Han);//H-E 朗道漢英字典
		dict_hz('hanja.db', $Han);
		dict_hz('kanji.db', $Han);
		dict_hz('cdict.db', $Han);//H-H CDICT國語辭典
	}
}
function dict_hz($db, $Words)
{
	$pdod = new PDO('sqlite:a/dbz/'.$db);
	$query = "SELECT * FROM dict WHERE Words='$Words'";
	foreach($pdod->query($query) as $row)
	{
		echo $row['Words'] . ' ▫ ' . stripslashes($row['Meaning']) . '<div class=dotted></div>';
	}
}
function dict_cedict_ts($Words)
{
	$pdod = new PDO('sqlite:a/dbz/cedict_ts.db');
	$query = "SELECT * FROM dict WHERE Words='$Words'";
	foreach($pdod->query($query) as $row)
	{
		$Words = $row['Words'];
		$Pinyin = $row['Pinyin'];
		$Meaning = stripslashes($row['Meaning']);
		echo $Words . $Pinyin . ' ▫ ' . $Meaning . '<br>';
	}
}
function dict_search()
{
	botcheck();
	$_SESSION['dict_option'] = true;
	$_SESSION['dict_Num'] = $_POST['Num'];
	$_SESSION['dict_Search'] = pretty_search($_POST['Search']);
	
	if(isset($_GET['mode']))
	{
		$_SESSION['Starting'] = 0;
		$_SESSION['dict_Mode'] = $_GET['mode'];
	}
	else if(isset($_GET['prev']))
	{
		$_SESSION['Starting'] = 0 + $_SESSION['Starting'] - 25;
	}
	else if(isset($_GET['next']))
	{
		$_SESSION['Starting'] = 0 + $_SESSION['Starting'] + 25;
	}
	else
	{
		$_SESSION['Starting'] = 0;
		$_SESSION['dict_Mode'] = "=";
	}
	$Num = $_SESSION['dict_Num'];
	$search = $_SESSION['dict_Search'];
	$mode = $_SESSION['dict_Mode'];
	
	if($Num == 'All')
	{
		$rval = "";
		$n = dict_data($Num, $search, $mode);
		if($n == 0 && $rval != "")
		{
			$_SESSION['dict_Search'] = $rval;
			$search = $_SESSION['dict_Search'];
			$n = dict_data($Num, $search, $mode);
		}
		if($mode == "=" && $n == 0) 
		{
			$mode = "like";
			$_SESSION['dict_Mode'] = $mode;
			$_SESSION['dict_option'] = false;
			$n = dict_data($Num, $search, $mode);
		}
		navigation($search, $mode, $n, isset($_GET['description']));
	}
	else
	{
		if($search == '')
		{
			$_SESSION['dict_option'] = false;
			$n = dict_data($Num, $search, $mode);
		}
		else
		{
			$n = dict_data($Num, $search, $mode);
			if($mode == "=" && $n == 0) 
			{
				$mode = "like";
				$_SESSION['dict_Mode'] = $mode;
				$n = dict_data($Num, $search, $mode);
			}
		}
		navigation($search, $mode, $n, isset($_GET['description']));
	}
}
function dict_data($Num, $search, $mode)
{
	$sql = "";
	if($Num != "All") $sql = "WHERE Num=" . $Num;
	$sql .= $sql == "" ? "WHERE ":" AND ";
	
	$L = $R = "%%";
	if($mode == "=") $L = $R = "";
	else $mode = "like";
	
	$sql .= "(Word " . $mode . " '" . $L . $search . $R . "' ";
	$sql .= "OR Word2 " . $mode . " '" . $L . $search . $R . "' ";
	
	if($mode == "like" && isset($_GET['description']))
	{
		$sql .= "OR Meaning " . $mode . " '" . $L . $search . $R . "' ";
		$sql .= "OR MeaningHV " . $mode . " '" . $L . $search . $R . "' ";
	}
	
	$sql .= "OR WordHV " . $mode . " '" . $L . $search . $R . "' )";
	
	if($Num != "All" && $search == '') $sql = "WHERE Num=" . $Num;
	
	$n = 0;
	$pdod = new PDO('sqlite:'.$_POST['currentpath'].'/dict-budhism---.db');
	$query = "SELECT * FROM dict_data $sql LIMIT " . $_SESSION['Starting'] . ", 25";//ORDER BY Num ASC, ID ASC
	foreach($pdod->query($query) as $row)
	{
		echo '<div class=dotted>' . ($_SESSION['Starting'] + ++$n);
		$Word = $row['Word'];
		$WordHV = dialecthan($row['WordHV']);
		$Meaning = $row['Meaning'];
		$MeaningHV = preg_replace('/\\n/i', "<br>", dialecthan(stripslashes($row['MeaningHV'])));
		
		if($MeaningHV != "")
		{
			if($WordHV == "") $WordHV = $Word;
			echo '.<sub>' . $row['Num'] . '</sub> <span style="color:#993300;">' . $WordHV . '</span></div>'; 
			echo '<div id=text' . $n . '>';
			echo $MeaningHV;
			echo '</div>';
			echo "<script>dictq('text" . $n . "');</script>";
		}
		else 
		{
			if($WordHV == "") $WordHV = $Word;
			echo '.<sub>' . $row['Num'] . '</sub> <span style="color:#993300;">' . $WordHV . '</span></div>'; 
			echo $Meaning;
			echo '<br>';
		}
		echo '<br>';
	}
	return $n;
}
function buddhismDict()
{
	$ajax = "ajax('dict.php', 'Dict', 'display');";
	echo '<form name="Dict" method="post" onsubmit="return false;">';
	echo '<SELECT style="width:70%;" name="Num" onchange="' . $ajax . '">';
	
	echo '<OPTION value="All">' . lang('All Dictionaries', 'Tất Cả Từ Điển') . '</OPTION>';
	
	$text = '';
	$pdod = new PDO('sqlite:'.$_SESSION['currentpath'].'/dict-budhism---.db');
	$query = "SELECT * FROM dict_name";
	foreach($pdod->query($query) as $row)
	{
		$text .= '<li>' . lang($row['English'], $row['Viet']).' <sup>'. $row['Total'] .' '.lang('entries', 'từ') .'</sup></li>';
		$name = " &nbsp;" . $row['Num'] . ". " . lang($row['English'], $row['Viet']);
		$value = $row['Num'];
		$s = $value == "All" ? 'selected="selected"':"";
		echo '<OPTION ' . $s . ' value="' . $value . '">' . $name . '</OPTION>';
	}
	echo '</SELECT>';
	
	echo '<input spellcheck="false" name="Search" type="text" style="width:27%;"';
	echo ' onchange="' . $ajax . '">';
	echo '<input type=hidden name=activate value=dict_search>';
	echo '<input type=hidden name=currentpath value="'.$_SESSION['currentpath'].'">';
	echo '</form>';
	
	echo '<div id=display>';
	echo '<ul>' . $text . '</ul>';
	echo '</div>';
	showdict();
}
/*
function allDict()
{
	$a = array(
		'1Longman-Dictionary-of-Contemporary-English'=>'Longman Dictionary of Contemporary English',
		'1Oxford-Advanced Learners-Dictionary'=>'Oxford Advanced Learner\'s Dictionary',
		'1Collins-Cobuild-English-Dictionary'=>'Collins Cobuild English Dictionary',
		'1Merrian-Webster-10th-Dictionary'=>'Merrian Webster 10th Dictionary',
	);
	$b = array(
		'anhviet'=>lang('English - Vietnamese', 'Anh - Việt'),
		'bodaonhaviet'=>lang('Portuguese - Vietnamese', 'Bồ Đào Nha - Việt'),
		'ducviet'=>lang('German - Vietnamese', 'Đức - Việt'),
		'hanviet'=>lang('Korean - Vietnamese', 'Hàn - Việt'),
		'nauyviet'=>lang('Norwegian - Vietnamese', 'Na Uy - Việt'),
		'ngaviet'=>lang('Russian - Vietnamese', 'Nga - Việt'),
		'nhatviet'=>lang('Japanese - Vietnamese', 'Nhật - Việt'),
		'phapviet'=>lang('French - Vietnamese', 'Pháp - Việt'),
		'secviet'=>lang('Czech - Vietnamese', 'Séc - Việt'),
		'taybannhaviet'=>lang('Spanish - Vietnamese', 'Tây Ban Nha - Việt'),
		'trungviet'=>lang('Chinese - Vietnamese', 'Trung - Việt'),
		'yviet'=>lang('Italian - Vietnamese', 'Ý - Việt'),
		'vietanh'=>lang('Vietnamese - English', 'Việt - Anh'),
		'vietduc'=>lang('Vietnamese - German', 'Việt - Đức'),
		'viethan'=>lang('Vietnamese - Korean', 'Việt - Hàn'),
		'vietnga'=>lang('Vietnamese - Russian', 'Việt - Nga'),
		'vietnhat'=>lang('Vietnamese - Japanese', 'Việt - Nhật'),
		'vietphap'=>lang('Vietnamese - French', 'Việt - Pháp'),
		'viettaybannha'=>lang('Vietnamese - Spanish', 'Việt - Tây Ban Nha'),
	);
	$c = english() ? $a : array_merge($a, $b);
	
	$rand = array_rand($c, 1);
	$ajax = "ajax('".basename(__FILE__)."', 'Dict', 'display');";
	echo '<form name="Dict" method="post" onsubmit="return false;">';
	echo '<SELECT style="width:70%;" name="Name" onchange="' . $ajax . '">';
	foreach($c as $key => $value)
	{
		$s = $key == $rand ? 'selected="selected"':"";
		echo '<OPTION ' . $s . ' value="' . $key . '">' . $value . '</OPTION>';
	}
	echo '</SELECT>';
	
	echo '<input spellcheck="false" name="Search" type="text" style="width:27%;"';
	echo ' onchange="' . $ajax . '">';
	echo '<input type=hidden name=activate value=mydict_search>';
	echo '</form>';
	
	echo '<div id=display>';
	$_POST['Name'] = $rand;
	$_POST['Search'] = '';
	mydict_search();
	echo '</div>';
}*/
function allDict($Name)
{
	$ajax = "ajax('".basename(__FILE__)."', 'Dict', 'display');";
	echo '<form name="Dict" method="post" onsubmit="return false;">';
	echo '<input spellcheck="false" name="Search" type="text" style="width:100%;"';
	echo ' onchange="' . $ajax . '">';
	echo '<input type=hidden name=activate value=mydict_search>';
	echo ' <input type=hidden name=currentpath value="'.$_SESSION['currentpath'].'">';
	echo '</form>';
	
	echo '<div id=display>';
	$_SESSION[$_SESSION['currentpath']] = $Name;
	$_POST['Search'] = '';
	mydict_search();
	echo '</div>';
}
function mydict_search()
{
	botcheck();
	$_POST['Search'] = str_replace("'", "’", trim($_POST['Search']));
	
	$_SESSION['dict_option'] = true;
	$_SESSION['dict_Search'] = addslashes($_POST['Search']);
	
	if(isset($_GET['mode']))
	{
		$_SESSION['Starting'] = 0;
		$_SESSION['dict_Mode'] = $_GET['mode'];
	}
	else if(isset($_GET['prev']))
	{
		$_SESSION['Starting'] = 0 + $_SESSION['Starting'] - 25;
	}
	else if(isset($_GET['next']))
	{
		$_SESSION['Starting'] = 0 + $_SESSION['Starting'] + 25;
	}
	else
	{
		$_SESSION['Starting'] = 0;
		$_SESSION['dict_Mode'] = "=";
	}
	
	$search = $_SESSION['dict_Search'];
	$mode = $_SESSION['dict_Mode'];
	
	if($search == '')
	{
		$_SESSION['dict_option'] = false;
		$n = mydict_data($search, $mode);
	}
	else
	{
		$n = mydict_data($search, $mode);
		if($mode == "=" && $n == 0) 
		{
			$mode = "like";
			$_SESSION['dict_Mode'] = $mode;
			$n = mydict_data($search, $mode);
		}
	}
	navigation($search, $mode, $n, isset($_GET['description']));
}
function mydict_data($search, $mode)
{
	$path = '';
	if(isset($_POST['currentpath']))
	{
		$path = $_POST['currentpath'];
	}
	else
	{
		$path = $_SESSION['currentpath'];
	}
	
	$Name = $_SESSION[$path];
	
	if($Name == '') return;
	
	$L = $R = "%";
	if($mode == "=") $L = $R = "";
	else $mode = "like";
	
	$sql = "WHERE (Words " . $mode . " '" . $L . $search . $R . "' ";
	if($mode == "like" && isset($_GET['description']))
	{
		$sql .= "OR Meaning " . $mode . " '" . $L . $search . $R . "' ";
	}
	$sql .= ')';
	if($search == '') $sql = '';
	
	$n = 0;
	$pdod = new PDO('sqlite:'.$path.'/'.$Name.'---.db');
	$query = "SELECT * FROM dict $sql LIMIT " . $_SESSION['Starting'] . ", 25";
	foreach($pdod->query($query) as $row)
	{
		$Words = $row['Words'];
		$Meaning = str_replace(array('\n', '  '), array('<br>', '&nbsp;&nbsp;'), $row['Meaning']);
		$Meaning = preg_replace(
						array('/({)(.*?)(})/'), 
						array("<em>$2</em>"), $Meaning);
						
		if(substr($Name, 0, 1) != '1')
		{
			$Meaning = preg_replace(
						array('/(=)(.*?)(\+)/', 
						'/(\[)(.*?)(\])/', 
						'/(#)(.*?)(<br>)/', 
						'/(@)(.*?)(<br>)/', 
						'/(\* )(.*?)(<br>)/'), 
						array("&nbsp;&nbsp;&nbsp;&nbsp;<em>$2:</em>", 
						"<em>$2</em>", 
						"<sub>$2</sub>$3", 
						"<em>$2</em>$3", 
						"<sub>$2</sub>$3")
						, $Meaning);
		}						
						
		echo '<div class=dotted><sup>' . ($_SESSION['Starting'] + ++$n);
		echo '</sup> <span style="color:#993300;">' . $Words . '</span></div>'; 
		echo $Meaning;
		echo '<br>';
		echo '<br>';
	}
	return $n;
}
function httpPost($mode)
{
	return "ajax('".basename(__FILE__)."?".$mode."', 'Dict', 'display');";
}
function navigation($search, $mode, $n, $description)
{
	echo '<div class=dotted></div><div style="text-align:center;">';

	if($_SESSION['Starting'] >= 25)
	{
		echo '<a href="javascript:void(0);" class=bright';
		echo ' onclick="' . httpPost(($description ? 'description&':'') . 'prev=' . ($_SESSION['Starting'] - 25)) . '">&nbsp;&nbsp;«&nbsp;&nbsp;</a> &nbsp; ';
	}
	
	if($_SESSION['Starting'] + $n >= 25)
	{
		echo (0 + $_SESSION['Starting'] + 1) . ' ▫ ' . (25 + $_SESSION['Starting']);
	}
	
	if($_SESSION['Starting'] >= 0 && $n >= 25)
	{
		echo ' &nbsp; <a href="javascript:void(0);" class=bright';
		echo ' onclick="' . httpPost(($description ? 'description&':'') . 'next=' . ($_SESSION['Starting'] + 25)) . '">&nbsp;&nbsp;»&nbsp;&nbsp;</a>';
	}
	
	if($_SESSION['dict_option'])
	{
		echo '<br>' . lang('Exact keyword', 'Từ khóa chính xác') . ' <a href="javascript:void(0);" class=box' . ($mode == "=" ? "c":"");
		echo ' onclick="' . httpPost('mode==') . '">★</a><br>';
	}
	
	if($_SESSION['dict_option'])
	{
		echo lang('Similar keyword', 'Từ khóa tương tự') . ' <a href="javascript:void(0);" class=box' . ($mode == "like" ? "c":"");
		echo ' onclick="' . httpPost('mode=like') . '">✪</a>';
	}
	
	if($search != '')
	{
		echo '<br>' . lang('Search in description', 'Tìm kiếm trong phần mô tả') . ' <a href="javascript:void(0);" class=box' . ($mode == "like" && $description ? "c":"");
		echo ' onclick="' . httpPost('mode=like&description') . '" class=box>✤</a><br>';
	}
		
	if($n == 0) 
	{
		echo lang('Sorry, no result found.', 'Xin lỗi, không tìm thấy kết quả.');
	}
	echo '</div>';
}
function botcheck()
{
	if(!isset($_SESSION['microtime']))
	{
		$_SESSION['microtime'] = microtime(true);
	}
	else
	{
		$now = microtime(true);
		$time = $now - $_SESSION['microtime'];
		$_SESSION['microtime'] = $now;
		if($time < 0.1) exit();
	}
}
function han_viet($Han)
{
	$HanMD5 = md5($Han);
	global $pdoa;
	$query = "SELECT * FROM han_viet WHERE HanMD5='$HanMD5' ORDER BY Enable DESC";
	foreach($pdoa->query($query) as $row)
	{
		$s = $row['Meaning'];
		echo ($row['Enable'] ? '<span>':'<span style="color:grey;">') . $row['Han'] . $row['Viet'] . '</span> ▫ <input type=text id=' . $row['MD5'] . ' onchange="dict_edit(\'' . $row['MD5'] . '\');" value="' . $s . '" style="width:70%; border:0px;"><span id=status' . $row['MD5'] . '></span><br>';
	}
	echo '<div class=dotted></div>';
}
function dict_edit()
{
	$MD5 = $_GET['MD5'];
	$text = addslashes(trim($_GET['text']));
	global $pdoa;
	if($text == 'delete')
	{
		$sql = "DELETE FROM han_viet WHERE MD5='$MD5'";
		$stmt = $pdoa->prepare($sql);
		if($stmt->execute()) echo "☺";
		else echo '☹';
	}
	else
	{
		if($text == 'enable')
		{
			$sql = "UPDATE han_viet SET Enable=1 WHERE MD5='$MD5'";
			$stmt = $pdoa->prepare($sql);
			if($stmt->execute()) echo "☺";
			else echo '☹';
		}
		else if($text == 'disable')
		{
			$sql = "UPDATE han_viet SET Enable=0 WHERE MD5='$MD5'";
			$stmt = $pdoa->prepare($sql);
			if($stmt->execute()) echo "☺";
			else echo '☹';
		}
		else
		{
			$sql = "UPDATE han_viet SET Meaning='$text' WHERE MD5='$MD5'";
			$stmt = $pdoa->prepare($sql);
			if($stmt->execute()) echo "☺";
			else echo '☹';
		}
	}
}
?>